/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.world.level.block.plant.other;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallFungusBlock
extends BushBlock {
    public static final MapCodec<? extends WallFungusBlock> CODEC = WallFungusBlock.simpleCodec(WallFungusBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public WallFungusBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> WallFungusBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
            case Direction.NORTH -> WallFungusBlock.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.EAST -> WallFungusBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
            case Direction.WEST -> WallFungusBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockposn = pos.north();
        BlockPos blockposs = pos.south();
        BlockPos blockpose = pos.east();
        BlockPos blockposw = pos.west();
        if (direction == Direction.SOUTH) {
            return level.getBlockState(blockposn).isFaceSturdy((BlockGetter)level, blockposn, Direction.SOUTH);
        }
        if (direction == Direction.NORTH) {
            return level.getBlockState(blockposs).isFaceSturdy((BlockGetter)level, blockposs, Direction.NORTH);
        }
        if (direction == Direction.WEST) {
            return level.getBlockState(blockpose).isFaceSturdy((BlockGetter)level, blockpose, Direction.WEST);
        }
        if (direction == Direction.EAST) {
            return level.getBlockState(blockposw).isFaceSturdy((BlockGetter)level, blockposw, Direction.EAST);
        }
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

