/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.platform;

import java.util.ServiceLoader;
import net.regions_unexplored.Constants;
import net.regions_unexplored.platform.services.IBlockHelper;
import net.regions_unexplored.platform.services.IParticleRegistry;
import net.regions_unexplored.platform.services.IPlatformHelper;
import net.regions_unexplored.platform.services.IRegistar;
import net.regions_unexplored.platform.services.IRenderHelper;
import net.regions_unexplored.platform.services.ITintHelper;

public class Services {
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    public static final IRegistar REGISTAR = Services.load(IRegistar.class);
    public static final IRenderHelper RENDER_HELPER = Services.load(IRenderHelper.class);
    public static final ITintHelper TINT_HELPER = Services.load(ITintHelper.class);
    public static final IParticleRegistry PARTICLES = Services.load(IParticleRegistry.class);
    public static final IBlockHelper BLOCK_HELPER = Services.load(IBlockHelper.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Constants.LOG.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

