/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.gen;

import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.Apotheosis;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class BossDungeonFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();
    private static final BlockState BRICK = Blocks.STONE_BRICKS.defaultBlockState();
    private static final BlockState MOSSY_BRICK = Blocks.MOSSY_STONE_BRICKS.defaultBlockState();
    private static final BlockState CRACKED_BRICK = Blocks.CRACKED_STONE_BRICKS.defaultBlockState();
    private static final BlockState[] BRICKS = new BlockState[]{BRICK, MOSSY_BRICK, CRACKED_BRICK};

    public BossDungeonFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        BlockState state;
        BlockPos blockpos;
        int z;
        int y;
        int x;
        WorldGenLevel world = ctx.level();
        if (!AdventureConfig.canGenerateIn(world)) {
            return false;
        }
        BlockPos pos = ctx.origin();
        RandomSource rand = ctx.random();
        int xRadius = 3 + rand.nextInt(3);
        int floor = -1;
        int roof = 4;
        int zRadius = 3 + rand.nextInt(3);
        int doors = 0;
        BlockState[][][] states = new BlockState[xRadius * 2 + 1][6][zRadius * 2 + 1];
        for (x = -xRadius; x <= xRadius; ++x) {
            for (y = floor; y <= roof; ++y) {
                for (z = -zRadius; z <= zRadius; ++z) {
                    blockpos = pos.offset(x, y, z);
                    state = world.getBlockState(blockpos);
                    boolean flag = state.isSolid();
                    if (y == floor && !flag || y == roof && !flag) {
                        return false;
                    }
                    if ((x == -xRadius || x == xRadius || z == -zRadius || z == zRadius) && y == 1 && state.isAir() && states[x + xRadius][y - 1 + 1][z + zRadius].isAir()) {
                        ++doors;
                    }
                    states[x + xRadius][y + 1][z + zRadius] = state;
                }
            }
        }
        if (doors >= 1 && doors <= 5) {
            for (x = -xRadius; x <= xRadius; ++x) {
                for (y = roof - 1; y >= floor; --y) {
                    for (z = -zRadius; z <= zRadius; ++z) {
                        blockpos = pos.offset(x, y, z);
                        state = states[x + xRadius][y + 1][z + zRadius];
                        if (x != -xRadius && y != floor && z != -zRadius && x != xRadius && y != roof && z != zRadius) {
                            if (state.is(Blocks.CHEST)) continue;
                            world.setBlock(blockpos, CAVE_AIR, 2);
                            continue;
                        }
                        if (y > floor && !states[x + xRadius][y - 1 + 1][z + zRadius].isSolid()) {
                            world.setBlock(blockpos, CAVE_AIR, 2);
                            continue;
                        }
                        if (!state.isSolid() || state.is(Blocks.CHEST)) continue;
                        if (y == floor) {
                            world.setBlock(blockpos, BRICKS[rand.nextInt(3)], 2);
                            continue;
                        }
                        world.setBlock(blockpos, rand.nextBoolean() ? BRICK : BRICKS[rand.nextInt(3)], 2);
                    }
                }
            }
            int xChestRadius = xRadius - 1;
            int zChestRadius = zRadius - 1;
            block6: for (int chests = 0; chests < 2; ++chests) {
                for (int attempts = 0; attempts < 3; ++attempts) {
                    boolean wall = rand.nextBoolean();
                    int x2 = wall ? (rand.nextBoolean() ? -xChestRadius : xChestRadius) : rand.nextInt(xChestRadius * 2 + 1) - xChestRadius;
                    int y2 = 0;
                    int z2 = !wall ? (rand.nextBoolean() ? -zChestRadius : zChestRadius) : rand.nextInt(zChestRadius * 2 + 1) - zChestRadius;
                    BlockPos blockpos2 = pos.offset(x2, y2, z2);
                    if (!world.getBlockState(blockpos2).isAir()) continue;
                    int nearbySolids = 0;
                    for (Direction dir : Direction.Plane.HORIZONTAL) {
                        if (!world.getBlockState(blockpos2.relative(dir)).isSolid()) continue;
                        ++nearbySolids;
                    }
                    if (nearbySolids != true) continue;
                    world.setBlock(blockpos2, StructurePiece.reorient((BlockGetter)world, (BlockPos)blockpos2, (BlockState)Blocks.CHEST.defaultBlockState()), 2);
                    RandomizableContainer.setBlockEntityLootTable((BlockGetter)world, (RandomSource)rand, (BlockPos)blockpos2, (ResourceKey)BuiltInLootTables.SIMPLE_DUNGEON);
                    continue block6;
                }
            }
            world.setBlock(pos, ((Block)Apoth.Blocks.BOSS_SPAWNER.value()).defaultBlockState(), 2);
            Apotheosis.debugLog(pos, "Boss Dungeon");
            return true;
        }
        return false;
    }
}

