/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWood;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor.BWGProcessorRules;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor.processors.FruitBlockProcessor;
import net.potionstudios.biomeswevegone.world.level.levelgen.structure.processor.processors.PlantProcessor;

public class BWGStructureProcessorLists {
    public static final Map<ResourceKey<StructureProcessorList>, StructureProcessorListFactory> STRUCTURE_PROCESSOR_LIST_FACTORIES = new Reference2ObjectOpenHashMap();
    public static final ResourceKey<StructureProcessorList> PRAIRIE_HOUSE = BWGStructureProcessorLists.register("prairie_house", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{BWGProcessorRules.GRASS_RANDOM_DIRT_PODZOL_COARSE_DIRT, BWGProcessorRules.STONE_RANDOM_COBBLESTONE_MOSSY}))));
    public static final ResourceKey<StructureProcessorList> ABANDONED_PRAIRIE_HOUSE = BWGStructureProcessorLists.register("abandoned_prairie_house", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{BWGProcessorRules.DIRT_RANDOM_GRASS_COARSE_DIRT_PODZOL, BWGProcessorRules.STONE_RANDOM_COBBLESTONE_MOSSY, BWGProcessorRules.MOSSIFY_70_PERCENT}))));
    public static final ResourceKey<StructureProcessorList> ASPEN_MANOR = BWGStructureProcessorLists.register("aspen_manor", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(BWGProcessorRules.SWEETBERRY_BLUEBERRY_50_PERCENT_RANDOM_AGE))));
    public static final ResourceKey<StructureProcessorList> FORGOTTEN_VILLAGE_BLOCKS = BWGStructureProcessorLists.register("forgotten_village_blocks", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{BWGProcessorRules.FORGOTTEN_ROCKY_STONE, BWGProcessorRules.FORGOTTEN_MOSSY_STONE_BRICKS, {BWGProcessorRules.FORGOTTEN_GRAVEL, BWGProcessorRules.FORGOTTEN_LUSH_GRASS_BLOCK}}))));
    public static final ResourceKey<StructureProcessorList> SKYRIS_STREETS = BWGStructureProcessorLists.register("skyris_streets", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{{BWGProcessorRules.streetWater(Blocks.POLISHED_ANDESITE, BWGWood.SKYRIS.planks())}, BWGProcessorRules.POLISHED_ANDESITE_RANDOM_ANDESITE_GRAVEL}))));
    public static final ResourceKey<StructureProcessorList> SKYRIS_TEMPLE = BWGStructureProcessorLists.register("skyris_temple", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{BWGProcessorRules.POLISHED_ANDESITE_RANDOM_ANDESITE_GRAVEL, BWGProcessorRules.STONEBRICKS_VARIANTS, {BWGProcessorRules.WHITE_DACITE_10_PERCENT_COBBLED_WHITE_DACITE}}))));
    public static final ResourceKey<StructureProcessorList> SKYRIS_LIBRARY = BWGStructureProcessorLists.register("skyris_library", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{BWGProcessorRules.POLISHED_ANDESITE_RANDOM_ANDESITE_GRAVEL, BWGProcessorRules.WHITE_DACITE_VARIANTS}))));
    public static final ResourceKey<StructureProcessorList> SKYRIS_FLETCHER_HOUSE = BWGStructureProcessorLists.register("skyris_fletcher_house", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{BWGProcessorRules.PODZOL_10_PERCENT_ANDESITE, {BWGProcessorRules.PODZOL_25_PERCENT_COARSE_DIRT, BWGProcessorRules.PODZOL_10_PERCENT_GRAVEL}}))));
    public static final ResourceKey<StructureProcessorList> SKYRIS_FORAGER_HOUSE = BWGStructureProcessorLists.register("skyris_forager_house", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{BWGProcessorRules.POLISHED_ANDESITE_RANDOM_ANDESITE_GRAVEL, {BWGProcessorRules.PODZOL_25_PERCENT_COARSE_DIRT, BWGProcessorRules.PODZOL_50_PERCENT_LUSH_GRASS, BWGProcessorRules.skyrisLeavesToGreenAppleLeaves(0.15f), BWGProcessorRules.skyrisLeavesToFlowering(0.2f)}}), (Object)((Object)new FruitBlockProcessor(BWGBlocks.GREEN_APPLE_FRUIT_BLOCK.get())))));
    public static final ResourceKey<StructureProcessorList> SKYRIS_TOWN_CENTERS = BWGStructureProcessorLists.register("skyris_town_centers", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{BWGProcessorRules.POLISHED_ANDESITE_RANDOM_ANDESITE_GRAVEL, {BWGProcessorRules.skyrisLeavesToGreenAppleLeaves(0.15f), BWGProcessorRules.skyrisLeavesToFlowering(0.2f)}}), (Object)((Object)new FruitBlockProcessor(BWGBlocks.GREEN_APPLE_FRUIT_BLOCK.get())))));
    public static final ResourceKey<StructureProcessorList> SALEM_TOWN_CENTER = BWGStructureProcessorLists.register("salem_town_center", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{BWGProcessorRules.STONE_SLAB_RANDOM_ANDESITE_ROCKY_SLAB, BWGProcessorRules.STONE_RANDOM_ROCKY_ANDESITE, {BWGProcessorRules.lushDirtToCoarseDirt(0.4f)}}))));
    public static final ResourceKey<StructureProcessorList> SALEM_STREETS = BWGStructureProcessorLists.register("salem_streets", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(BWGProcessorRules.streetWater((Block)BWGBlocks.LUSH_DIRT_PATH.get(), BWGWood.WITCH_HAZEL.planks()), BWGProcessorRules.lushDirtToCoarseDirt(0.3f)))));
    public static final ResourceKey<StructureProcessorList> SALEM_HOUSES = BWGStructureProcessorLists.register("salem_houses", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{{BWGProcessorRules.STRIPPED_OAK_LOG_60_PERCENT_OAK_PLANKS}, BWGProcessorRules.STONE_RANDOM_COBBLESTONE_MOSSY}))));
    public static final ResourceKey<StructureProcessorList> RED_ROCK_STREETS = BWGStructureProcessorLists.register("red_rock_streets", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{{BWGProcessorRules.streetWater(Blocks.ORANGE_TERRACOTTA, BWGWood.PINE.planks())}, BWGProcessorRules.ORANGE_TERRACOTTA_TO_RED_ROCK_CRACKED_RED_ROCK_BRICKS}))));
    public static final ResourceKey<StructureProcessorList> RED_ROCK_CRACKED_BRICKS_50_PERCENT_MOSSY_RED_ROCK_BRICKS = BWGStructureProcessorLists.register("red_rock_cracked_bricks_50_percent_mossy_red_rock_bricks", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(BWGProcessorRules.RED_ROCK_CRACKED_BRICKS_50_PERCENT_MOSSY_RED_ROCK_BRICKS))));
    public static final ResourceKey<StructureProcessorList> RED_ROCK_MEETING_POINT_1 = BWGStructureProcessorLists.register("red_rock_meeting_point_1", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(BWGProcessorRules.RED_ROCK_BRICKS_TO_ORANGE_TERRACOTTA, BWGProcessorRules.RED_ROCK_CRACKED_BRICKS_50_PERCENT_MOSSY_RED_ROCK_BRICKS))));
    public static final ResourceKey<StructureProcessorList> RED_ROCK_MEETING_POINT_3 = BWGStructureProcessorLists.register("red_rock_meeting_point_3", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(BWGProcessorRules.STRIPPED_BAOBAB_WOOD_50_PERCENT_BAOBAB_PLANKS))));
    public static final ResourceKey<StructureProcessorList> RED_ROCK_TO_BRICKS = BWGStructureProcessorLists.register("red_rock_to_bricks", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(BWGProcessorRules.RED_ROCK_25_PERCENT_CRACKED_RED_ROCK_BRICKS, BWGProcessorRules.RED_ROCK_25_PERCENT_RED_ROCK_BRICKS))));
    public static final ResourceKey<StructureProcessorList> RED_ROCK_HOUSE = BWGStructureProcessorLists.register("red_rock_house", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{{BWGProcessorRules.RED_ROCK_BRICKS_35_PERCENT_CRACKED_RED_ROCK_BRICKS}, BWGProcessorRules.RANDOM_DESERT_POTTED_PLANT}))));
    public static final ResourceKey<StructureProcessorList> PUMPKIN_PATCH_STREETS = BWGStructureProcessorLists.register("pumpkin_patch_streets", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(BWGProcessorRules.streetWater((Block)BWGBlocks.LUSH_DIRT_PATH.get(), Blocks.DARK_OAK_PLANKS), BWGProcessorRules.lushPathToBlock(0.15f, Blocks.PACKED_MUD), BWGProcessorRules.lushPathToBlock(0.4f, BWGBlocks.PEAT.get()), BWGProcessorRules.lushPathToBlock(0.4f, Blocks.COARSE_DIRT)))));
    public static final ResourceKey<StructureProcessorList> PUMPKIN_PATCH_HOUSE = BWGStructureProcessorLists.register("pumpkin_patch_house", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{{BWGProcessorRules.lushPathToBlock(0.15f, (Block)BWGBlocks.LUSH_GRASS_BLOCK.get()), BWGProcessorRules.lushPathToBlock(0.45f, BWGBlocks.PEAT.get()), BWGProcessorRules.lushPathToBlock(0.4f, Blocks.COARSE_DIRT), BWGProcessorRules.burrowToBlock(0.5f, Blocks.PUMPKIN), BWGProcessorRules.STRIPPED_DARK_OAK_WOOD_35_PERCENT_DARK_OAK_PLANKS}, BWGProcessorRules.DACITE_COBBLESTONE_VARIANTS, BWGProcessorRules.SHORT_GRASS_TO_FLOWER_PUMPKIN_PATCH, BWGProcessorRules.WHITE_PUFFBALL_RANDOM_AGE, BWGProcessorRules.PUMPKIN_RANDOM_AGE}))));
    public static final ResourceKey<StructureProcessorList> PUMPKIN_PATCH_FARM = BWGStructureProcessorLists.register("pumpkin_patch_farm", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(BWGProcessorRules.lushFarmLandToBlock((Block)BWGBlocks.LUSH_GRASS_BLOCK.get(), 0.5f), BWGProcessorRules.lushFarmLandToBlock(Blocks.WATER, 0.23f)), (Object)((Object)new PlantProcessor((Block)BWGBlocks.LUSH_FARMLAND.get(), Blocks.PUMPKIN_STEM, 0.5f)))));
    public static final ResourceKey<StructureProcessorList> PUMPKIN_PATCH_MEETING_POINT = BWGStructureProcessorLists.register("pumpkin_patch_meeting_point", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{{BWGProcessorRules.lushFarmLandToBlock((Block)BWGBlocks.LUSH_GRASS_BLOCK.get(), 0.5f), BWGProcessorRules.lushFarmLandToBlock(Blocks.WATER, 0.23f), BWGProcessorRules.lushPathToBlock(0.35f, (Block)BWGBlocks.LUSH_GRASS_BLOCK.get()), BWGProcessorRules.grassBlockToBlock(0.4f, (Block)BWGBlocks.LUSH_DIRT_PATH.get())}, BWGProcessorRules.DACITE_COBBLESTONE_VARIANTS}), (Object)((Object)new PlantProcessor((Block)BWGBlocks.LUSH_FARMLAND.get(), Blocks.PUMPKIN_STEM, 0.5f)))));
    public static final ResourceKey<StructureProcessorList> SWAMP_STREETS = BWGStructureProcessorLists.register("swamp_streets", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(BWGProcessorRules.tuffToBlock(0.15f, Blocks.MOSSY_COBBLESTONE), BWGProcessorRules.tuffToBlock(0.5f, Blocks.POLISHED_TUFF), BWGProcessorRules.tuffToBlock(0.5f, Blocks.TUFF_BRICKS)))));
    public static final ResourceKey<StructureProcessorList> SWAMP_HOUSE = BWGStructureProcessorLists.register("swamp_house", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{{BWGProcessorRules.tuffToBlock(0.15f, Blocks.MOSSY_COBBLESTONE), BWGProcessorRules.tuffToBlock(0.45f, Blocks.POLISHED_TUFF), BWGProcessorRules.tuffToBlock(0.4f, Blocks.TUFF_BRICKS), BWGProcessorRules.grassBlockToBlock(0.1f, Blocks.MOSS_BLOCK), BWGProcessorRules.chestToBlock(0.2f, Blocks.AIR)}, BWGProcessorRules.SHORT_GRASS_TO_FLOWER_SWAMP}))));
    public static final ResourceKey<StructureProcessorList> MOSSIFY_10_PERCENT_WHITE_PUFFBALL = BWGStructureProcessorLists.register("mossify_10_percent_white_puffball", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{{BWGProcessorRules.MOSSIFY_10_PERCENT}, BWGProcessorRules.WHITE_PUFFBALL_RANDOM_AGE}))));
    public static final ResourceKey<StructureProcessorList> BOG_TRIAL = BWGStructureProcessorLists.register("bog_trial", structureProcessorListHolderGetter -> new StructureProcessorList((List)ImmutableList.of((Object)BWGStructureProcessorLists.createRuleProcessor(new ProcessorRule[][]{{BWGProcessorRules.spiritLeavesToFlowering(0.5f), BWGProcessorRules.BOG_TRIAL_FLOOR}, BWGProcessorRules.WHITE_PUFFBALL_RANDOM_AGE}))));

    private static RuleProcessor createRuleProcessor(ProcessorRule ... rules) {
        return new RuleProcessor((List)ImmutableList.copyOf((Object[])rules));
    }

    private static RuleProcessor createRuleProcessor(ProcessorRule[] ... ruleGroups) {
        ArrayList combined = new ArrayList();
        for (ProcessorRule[] group : ruleGroups) {
            Collections.addAll(combined, group);
        }
        return new RuleProcessor((List)ImmutableList.copyOf(combined));
    }

    private static ResourceKey<StructureProcessorList> register(String id, StructureProcessorListFactory factory) {
        ResourceKey structureProcessorListResourceKey = BiomesWeveGone.key(Registries.PROCESSOR_LIST, id);
        STRUCTURE_PROCESSOR_LIST_FACTORIES.put(structureProcessorListResourceKey, factory);
        return structureProcessorListResourceKey;
    }

    @FunctionalInterface
    public static interface StructureProcessorListFactory {
        public StructureProcessorList generate(HolderGetter<StructureProcessorList> var1);
    }
}

