/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.commands.AbstractCommand;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;

public class UpgradeCommand {

    protected static class ToDO
    extends AbstractCommand {
        private static final String NAME = "DO";
        private static final String START = "start";
        private static final String END = "end";
        private static final String WORLD = "world";

        protected ToDO() {
        }

        protected static LiteralArgumentBuilder<CommandSourceStack> build() {
            return (LiteralArgumentBuilder)ToDO.newLiteral(NAME).then(ToDO.newArgument(START, BlockPosArgument.blockPos()).then(ToDO.newArgument(END, BlockPosArgument.blockPos()).then(ToDO.newArgument(WORLD, DimensionArgument.dimension()).executes(ToDO::onExecute))));
        }

        private static int onExecute(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
            BlockPos start = BlockPosArgument.getSpawnablePos(command, (String)START);
            BlockPos end = BlockPosArgument.getSpawnablePos(command, (String)END);
            ServerLevel level = DimensionArgument.getDimension(command, (String)WORLD);
            BlockPos iterationStart = new BlockPos(Math.min(start.getX(), end.getX()), Math.min(start.getY(), end.getY()), Math.min(start.getZ(), end.getZ()));
            BlockPos iterationEnd = new BlockPos(Math.max(start.getX(), end.getX()), Math.max(start.getY(), end.getY()), Math.max(start.getZ(), end.getZ()));
            BlockPos.MutableBlockPos iterationPos = iterationStart.mutable();
            while (iterationPos.getX() <= iterationEnd.getX()) {
                while (iterationPos.getY() <= iterationEnd.getY()) {
                    while (iterationPos.getZ() <= iterationEnd.getZ()) {
                        BlockState blockState = level.getBlockState((BlockPos)iterationPos);
                        System.out.println(blockState);
                        iterationPos.move(Direction.SOUTH);
                    }
                    iterationPos.move(Direction.UP);
                }
                iterationPos.move(Direction.EAST);
            }
            return 0;
        }
    }
}

