/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.world.feature;

import com.mojang.serialization.Codec;
import com.stal111.forbidden_arcanus.common.block.CarvedEdelwoodLogBlock;
import com.stal111.forbidden_arcanus.common.block.EdelwoodBranchBlock;
import com.stal111.forbidden_arcanus.common.block.EdelwoodLogBlock;
import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class EdelwoodFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState EDELWOOD_LOG = ((EdelwoodLogBlock)((Object)ModBlocks.EDELWOOD_LOG.get())).defaultBlockState();
    private static final BlockState CARVED_EDELWOOD_LOG = (BlockState)((CarvedEdelwoodLogBlock)((Object)ModBlocks.CARVED_EDELWOOD_LOG.get())).defaultBlockState().setValue((Property)ModBlockStateProperties.LEAVES, (Comparable)Boolean.valueOf(true));
    private static final BlockState EDELWOOD_BRANCH = ((EdelwoodBranchBlock)((Object)ModBlocks.EDELWOOD_BRANCH.get())).defaultBlockState();
    private static final int MAX_HEIGHT = 4;
    private static final int MIN_HEIGHT = 2;

    public EdelwoodFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(@Nonnull FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int height;
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        BlockPos.MutableBlockPos mutable = pos.mutable();
        RandomSource random = context.random();
        if (!level.isEmptyBlock(pos.above()) || !level.getBlockState(pos.below()).is(BlockTags.DIRT)) {
            return false;
        }
        Direction direction = Direction.from2DDataValue((int)random.nextInt(4));
        for (height = 1; level.isEmptyBlock((BlockPos)mutable) && height <= 4; ++height) {
            if (height == 4 || !level.isEmptyBlock(mutable.above()) || height >= 2 && random.nextDouble() < 0.35) {
                level.setBlock((BlockPos)mutable, (BlockState)CARVED_EDELWOOD_LOG.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction), 2);
                break;
            }
            level.setBlock((BlockPos)mutable, EDELWOOD_LOG, 2);
            mutable.move(Direction.UP);
        }
        if (height >= 3 && random.nextDouble() < 0.65) {
            direction = direction.getClockWise();
            mutable.move(Direction.DOWN).move(direction);
            level.setBlock((BlockPos)mutable, (BlockState)EDELWOOD_BRANCH.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction), 2);
            mutable.move(direction.getOpposite(), 2);
            level.setBlock((BlockPos)mutable, (BlockState)EDELWOOD_BRANCH.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction.getOpposite()), 2);
        }
        return true;
    }
}

