/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block;

import com.stal111.forbidden_arcanus.common.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.block.properties.PillarType;
import java.util.EnumMap;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.api.common.helper.VoxelShapeHelper;

public class PillarBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<PillarType> TYPE = ModBlockStateProperties.PILLAR_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape[] SHAPE_PARTS = new VoxelShape[]{Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0)};
    private static final EnumMap<PillarType, EnumMap<Direction.Axis, VoxelShape>> SHAPES = (EnumMap)Util.make(new EnumMap(PillarType.class), map -> {
        map.put(PillarType.MIDDLE, VoxelShapeHelper.rotateAxis((VoxelShape)SHAPE_PARTS[2]));
        map.put(PillarType.TOP, VoxelShapeHelper.rotateAxis((VoxelShape)Shapes.or((VoxelShape)SHAPE_PARTS[0], (VoxelShape[])new VoxelShape[]{SHAPE_PARTS[1], SHAPE_PARTS[2]})));
        map.put(PillarType.BOTTOM, VoxelShapeHelper.rotateAxis((VoxelShape)Shapes.or((VoxelShape)SHAPE_PARTS[3], (VoxelShape[])new VoxelShape[]{SHAPE_PARTS[4], SHAPE_PARTS[2]})));
        map.put(PillarType.SINGLE, VoxelShapeHelper.rotateAxis((VoxelShape)VoxelShapeHelper.combineAll((VoxelShape[])SHAPE_PARTS)));
    });

    public PillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(TYPE, (Comparable)((Object)PillarType.SINGLE))).setValue((Property)AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue(TYPE)).get(state.getValue((Property)AXIS));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(context)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (direction.getAxis() != state.getValue((Property)AXIS)) {
            return state;
        }
        return (BlockState)state.setValue(TYPE, (Comparable)((Object)PillarBlock.calculatePillarType(state, level, currentPos)));
    }

    private static PillarType calculatePillarType(BlockState state, LevelAccessor level, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)AXIS);
        BlockState stateDown = level.getBlockState(pos.relative(Direction.get((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis)));
        BlockState stateUp = level.getBlockState(pos.relative(Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis)));
        boolean axisUpEqual = stateUp.is(state.getBlock()) && stateUp.getValue((Property)AXIS) == axis;
        boolean axisDownEqual = stateDown.is(state.getBlock()) && stateDown.getValue((Property)AXIS) == axis;
        return PillarType.getTypeForConnections(axisUpEqual, axisDownEqual);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TYPE, AXIS, WATERLOGGED});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

