/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.icetower;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.structures.lichtower.TowerRoofComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;

public class IceTowerRoofComponent
extends TowerRoofComponent {
    public IceTowerRoofComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super((StructurePieceType)TFStructurePieceTypes.TFITRoof.get(), nbt);
    }

    public IceTowerRoofComponent(int i, TowerWingComponent wing, int x, int y, int z) {
        super((StructurePieceType)TFStructurePieceTypes.TFITRoof.get(), i, x, y, z);
        this.setOrientation(wing.getOrientation());
        this.size = wing.size;
        this.height = IceTowerRoofComponent.getRHeight(this.size, this.size);
        this.deco = wing.deco;
        this.makeCapBB(wing);
    }

    @Override
    public void postProcess(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        super.postProcess(world, manager, generator, rand, sbb, chunkPosIn, blockPos);
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                int rHeight = IceTowerRoofComponent.getRHeight(x, z);
                for (int y = 0; y < rHeight; ++y) {
                    this.placeBlock(world, this.deco.blockState, x, y, z, sbb);
                }
            }
        }
    }

    private static int getRHeight(int x, int z) {
        return Math.round(Mth.sqrt((float)(x * x + z * z)));
    }
}

