/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import twilightforest.components.entity.SmashBlocksEnchantmentAttachment;
import twilightforest.entity.projectile.ChainBlock;
import twilightforest.init.TFDataAttachments;

public record SmashBlocksEffect(LevelBasedValue maxSmash, LevelBasedValue radius, Optional<HolderSet<Block>> immuneBlocks, Optional<HolderSet<Block>> vulnerableBlocks, Optional<Holder<SoundEvent>> smashSound) implements EnchantmentEntityEffect
{
    public static final MapCodec<SmashBlocksEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("max_smash").forGetter(SmashBlocksEffect::maxSmash), (App)LevelBasedValue.CODEC.fieldOf("radius").forGetter(SmashBlocksEffect::radius), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).optionalFieldOf("immune_blocks").forGetter(SmashBlocksEffect::immuneBlocks), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).optionalFieldOf("vulnerable_blocks").forGetter(SmashBlocksEffect::vulnerableBlocks), (App)SoundEvent.CODEC.optionalFieldOf("smash_sound").forGetter(SmashBlocksEffect::smashSound)).apply((Applicative)instance, SmashBlocksEffect::new));

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse item, Entity entity, Vec3 position) {
        LivingEntity livingEntity = item.owner();
        if (livingEntity instanceof ServerPlayer) {
            int maxSmash;
            ServerPlayer player = (ServerPlayer)livingEntity;
            int blocksSmashed = ((SmashBlocksEnchantmentAttachment)entity.getData(TFDataAttachments.SMASH_BLOCKS)).getBlocksSmashed();
            if (blocksSmashed >= (maxSmash = Math.round(this.maxSmash.calculate(enchantmentLevel)))) {
                return;
            }
            BlockPos start = BlockPos.containing((Position)position);
            int radius = Math.round(this.radius.calculate(enchantmentLevel));
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)start.offset(-radius, 0, -radius), (BlockPos)start.offset(radius, 0, radius))) {
                if (blocksSmashed >= maxSmash) break;
                BlockState state = level.getBlockState(pos);
                if (state.isAir() || this.immuneBlocks().isPresent() && this.immuneBlocks().get().contains(state.getBlockHolder()) || !ChainBlock.canBreakBlockAt((Level)level, pos, state, item.itemStack(), player.gameMode.getGameModeForPlayer().isBlockPlacingRestricted()) || !state.canEntityDestroy((BlockGetter)level, pos, (Entity)player) || ((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent((Level)level, pos, state, (Player)player))).isCanceled()) continue;
                level.destroyBlock(pos, false);
                if (!player.isCreative()) {
                    state.getBlock().playerDestroy((Level)level, (Player)player, pos, state, level.getBlockEntity(pos), item.itemStack());
                }
                if (this.smashSound().isPresent()) {
                    level.playSound(null, pos, (SoundEvent)this.smashSound().get().value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                ++blocksSmashed;
            }
            ((SmashBlocksEnchantmentAttachment)entity.getData(TFDataAttachments.SMASH_BLOCKS)).setBlocksSmashed(blocksSmashed);
        }
    }

    public MapCodec<? extends EnchantmentEntityEffect> codec() {
        return CODEC;
    }
}

