/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.FluidizerTankData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.MultiblockFluidizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerControllerEntity;
import it.zerono.mods.zerocore.lib.client.render.FluidTankRenderer;
import it.zerono.mods.zerocore.lib.data.geometry.CuboidBoundingBox;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidizerClientTankData
extends FluidizerTankData {
    private final FluidTankRenderer.Single _renderer;
    private final MultiblockFluidizer _controller;
    private final int _translationX;
    private final int _translationY;
    private final int _translationZ;

    public FluidizerClientTankData(FluidizerControllerEntity controllerEntity) {
        MultiblockFluidizer controller = (MultiblockFluidizer)controllerEntity.getMultiblockController().orElseThrow();
        CuboidBoundingBox box = controller.getBoundingBox();
        BlockPos min = box.getMin().offset(1, 1, 1);
        BlockPos offset = controllerEntity.getWorldPosition().subtract((Vec3i)min);
        this._renderer = new FluidTankRenderer.Single(controller.getFluidHandler().getTankCapacity(0), (float)min.getX(), (float)min.getY(), (float)min.getZ(), (float)(box.getMaxX() - 1), (float)(box.getMaxY() - 1), (float)(box.getMaxZ() - 1));
        this._controller = controller;
        this._translationX = -offset.getX();
        this._translationY = -offset.getY();
        this._translationZ = -offset.getZ();
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        FluidStack stack = this._controller.getFluidHandler().getFluidInTank(0);
        poseStack.translate((float)this._translationX, (float)this._translationY, (float)this._translationZ);
        this._renderer.render(poseStack, bufferSource, packedLight, stack);
        poseStack.translate((float)(-this._translationX), (float)(-this._translationY), (float)(-this._translationZ));
    }
}

