/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.gui.config;

import at.ridgo8.moreoverlays.gui.config.ConfigOptionList;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class OptionCategory
extends ConfigOptionList.OptionEntry {
    private final List<String> tooltip;
    private final Button btnOpen;

    public OptionCategory(ConfigOptionList list, List<String> path, String name, String comment) {
        super(list);
        this.btnOpen = new Button.Builder(Component.nullToEmpty((String)name), btn -> list.push(path)).pos(0, 0).size(this.getConfigOptionList().getRowWidth() - 4, 20).build();
        String[] lines = null;
        if (comment != null) {
            lines = comment.split("\\n");
            this.tooltip = new ArrayList<String>(lines.length + 1);
        } else {
            this.tooltip = new ArrayList<String>(1);
        }
        this.tooltip.add(String.valueOf(ChatFormatting.RED) + name);
        if (lines != null) {
            for (String line : lines) {
                this.tooltip.add(String.valueOf(ChatFormatting.YELLOW) + line);
            }
        }
    }

    @Override
    public void renderControls(GuiGraphics guiGraphics, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean mouseOver, float partialTick) {
        this.btnOpen.setPosition(rowLeft, rowTop);
        this.btnOpen.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderTooltip(GuiGraphics guiGraphics, int rowTop, int rowLeft, int rowWidth, int itemHeight, int mouseX, int mouseY) {
        guiGraphics.renderTooltip(Minecraft.getInstance().font, Component.nullToEmpty((String)this.tooltip.toString()), mouseX, mouseY);
    }

    @Override
    public List<? extends GuiEventListener> children() {
        return List.of(this.btnOpen);
    }

    public List<? extends NarratableEntry> narratables() {
        return ImmutableList.of((Object)new NarratableEntry(this){

            public NarratableEntry.NarrationPriority narrationPriority() {
                return NarratableEntry.NarrationPriority.HOVERED;
            }

            public void updateNarration(NarrationElementOutput output) {
                output.add(NarratedElementType.TITLE, "");
            }
        });
    }
}

