/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.registry;

import com.github.jarva.arsadditions.common.item.data.CharmData;
import com.github.jarva.arsadditions.common.util.CooldownManager;
import com.github.jarva.arsadditions.server.util.PlayerInvUtil;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CharmRegistry {
    private static CooldownManager<CharmType> cooldowns = new CooldownManager();

    public static boolean isEnabled(CharmType type, LivingEntity entity) {
        return !CharmRegistry.getCharm(entity, type).isEmpty();
    }

    public static boolean isEnabled(CharmType type, ItemStack charm) {
        return charm.is((Item)AddonItemRegistry.CHARMS.get((Object)type).get()) && CharmRegistry.isEnabled(charm);
    }

    public static boolean isEnabled(ItemStack charm) {
        return CharmRegistry.getCharges(charm) > 0;
    }

    public static int getCharges(ItemStack stack) {
        return CharmData.getOrDefault(stack).charges();
    }

    public static void useCharges(ItemStack stack, int charges) {
        CharmData.getOrDefault(stack).use(charges).write(stack);
    }

    public static void setCharges(ItemStack stack, int charges) {
        CharmData.getOrDefault(stack).set(charges).write(stack);
    }

    public static ItemStack getCharm(LivingEntity entity, CharmType charm) {
        return PlayerInvUtil.findItem(entity, stack -> CharmRegistry.isEnabled(charm, stack), ItemStack.EMPTY, Function.identity());
    }

    public static boolean processCharmEvent(LivingEntity entity, CharmType charm, Supplier<Boolean> predicate, BiFunction<LivingEntity, ItemStack, Integer> consumer) {
        Player player;
        if (!predicate.get().booleanValue()) {
            return false;
        }
        ItemStack curio = CharmRegistry.getCharm(entity, charm);
        if (curio == null || curio.isEmpty()) {
            return false;
        }
        int damage = consumer.apply(entity, curio);
        if (entity instanceof Player && (player = (Player)entity).isCreative()) {
            return true;
        }
        if (damage > 0) {
            CharmRegistry.useCharges(curio, damage);
        }
        return true;
    }

    public static int every(CharmType charmType, int ticks, LivingEntity entity, int charges) {
        return cooldowns.shouldRun(charmType, entity.level().getGameTime(), ticks) ? charges : 0;
    }

    public static enum CharmType implements StringRepresentable
    {
        FIRE_RESISTANCE(1000, 5, "Emberward", "Nullifies Fire Damage", new ItemLike[]{Items.MAGMA_CREAM, Items.LAVA_BUCKET, Items.FLINT_AND_STEEL}),
        UNDYING(1, 2000, "Second Wind", "Prevents you from dying", new ItemLike[]{Items.TOTEM_OF_UNDYING, Items.CRYING_OBSIDIAN, Items.GLOWSTONE}),
        DISPEL_PROTECTION(3, 1000, "Unyielding Magic", "Prevents you from being dispelled", new ItemLike[]{Items.MILK_BUCKET, Items.SHIELD, Items.SPIDER_EYE, Items.WITHER_ROSE}),
        FALL_PREVENTION(20, 20, "Featherlight", "Enables you to float down like a feather", new ItemLike[]{Items.FEATHER, Items.PHANTOM_MEMBRANE}),
        WATER_BREATHING(1000, 5, "Ocean's Breath", "Enables you to breath underwater", new ItemLike[]{Items.PUFFERFISH, Items.INK_SAC, Items.KELP}),
        ENDER_MASK(100, 10, "Ender Serenity", "Masks you from an Enderman's anger", new ItemLike[]{Items.PUMPKIN, Items.CHORUS_FRUIT}),
        VOID_PROTECTION(1, 2000, "Void's Salvation", "Saves you from the void", new ItemLike[]{ItemsRegistry.STABLE_WARP_SCROLL, Items.END_STONE_BRICKS}),
        SONIC_BOOM_PROTECTION(3, 1000, "Resonant Shield", "Protects you from the Warden's Sonic Boom", new ItemLike[]{Items.SCULK, Items.SHIELD, Items.WHITE_WOOL}),
        WITHER_PROTECTION(10, 100, "Decay's End", "Prevents you from being afflicted with Wither", new ItemLike[]{Items.WITHER_ROSE, Items.WITHER_SKELETON_SKULL, Items.MILK_BUCKET}),
        GOLDEN(1000, 5, "Gilded Friendship", "Makes Piglins neutral to the wearer", new ItemLike[]{Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS, Items.GILDED_BLACKSTONE}),
        NIGHT_VISION(20, 10, "Darkvision", "Enables the wearer to see in low-light environments", new ItemLike[]{Items.LANTERN, Items.TORCH}),
        POWDERED_SNOW_WALK(1000, 5, "Snowstride", "Enables the wearer to walk on powdered snow", new ItemLike[]{Items.LEATHER_BOOTS, Items.POWDER_SNOW_BUCKET});

        private final int charges;
        private final int costPerCharge;
        private final String name;
        private final String desc;
        private final ArrayList<ItemLike> pedestalItems = new ArrayList();

        private CharmType(int charges, int costPerCharge, String name, String desc, ItemLike ... items) {
            this.charges = charges;
            this.costPerCharge = costPerCharge;
            this.name = name;
            this.desc = desc;
            this.pedestalItems.addAll(List.of(items));
        }

        public int getCharges() {
            return this.charges;
        }

        public int getCostPerCharge() {
            return this.costPerCharge;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public ArrayList<ItemLike> getPedestalItems() {
            return this.pedestalItems;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ENGLISH) + "_charm";
        }
    }
}

