/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.networking;

import com.github.jarva.arsadditions.setup.networking.OpenNexusPacket;
import com.github.jarva.arsadditions.setup.networking.OpenTerminalPacket;
import com.github.jarva.arsadditions.setup.networking.SendLocalWeatherStatus;
import com.github.jarva.arsadditions.setup.networking.TeleportNexusPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="ars_additions", bus=EventBusSubscriber.Bus.MOD)
public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";

    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(PROTOCOL_VERSION);
        registrar.playToServer(TeleportNexusPacket.TYPE, TeleportNexusPacket.STREAM_CODEC, TeleportNexusPacket::handleData);
        registrar.playToClient(OpenNexusPacket.TYPE, OpenNexusPacket.STREAM_CODEC, OpenNexusPacket::handleData);
        registrar.playToServer(OpenTerminalPacket.TYPE, OpenTerminalPacket.STREAM_CODEC, OpenTerminalPacket::handleData);
        registrar.playToClient(SendLocalWeatherStatus.TYPE, SendLocalWeatherStatus.STREAM_CODEC, SendLocalWeatherStatus::handleData);
    }

    public static void sendToPlayerClient(CustomPacketPayload msg, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(CustomPacketPayload msg) {
        PacketDistributor.sendToServer((CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

