/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.data;

import com.github.jarva.arsadditions.setup.networking.SendLocalWeatherStatus;
import com.github.jarva.arsadditions.setup.registry.AddonAttachmentRegistry;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
public enum WeatherStatus implements StringRepresentable
{
    NONE(0),
    CLEAR(1),
    RAIN(2),
    SNOW(3),
    THUNDER(4);

    public static StringRepresentable.EnumCodec<WeatherStatus> CODEC;
    public static IntFunction<WeatherStatus> BY_ID;
    public static StreamCodec<ByteBuf, WeatherStatus> STREAM_CODEC;
    private final int id;

    private WeatherStatus(int i) {
        this.id = i;
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public String getSerializedName() {
        return this.name();
    }

    @SubscribeEvent
    public static void sendChunkData(ChunkWatchEvent.Sent event) {
        ServerPlayer player = event.getPlayer();
        LevelChunk chunk = event.getChunk();
        ChunkPos pos = event.getPos();
        if (chunk.hasData(AddonAttachmentRegistry.LOCAL_WEATHER)) {
            WeatherStatus status = (WeatherStatus)((Object)chunk.getData(AddonAttachmentRegistry.LOCAL_WEATHER));
            SendLocalWeatherStatus.sendChunkStatus(player, pos, status);
        } else {
            SendLocalWeatherStatus.sendChunkStatus(player, pos, NONE);
        }
    }

    @SubscribeEvent
    public static void setWeatherStatus(ChunkWatchEvent.Watch event) {
        LevelChunk chunk = event.getChunk();
        if (FMLEnvironment.production) {
            chunk.setData(AddonAttachmentRegistry.LOCAL_WEATHER, (Object)NONE);
        }
        ServerPlayer player = event.getPlayer();
        ChunkPos pos = event.getPos();
        WeatherStatus[] values = WeatherStatus.values();
        if (!chunk.hasData(AddonAttachmentRegistry.LOCAL_WEATHER)) {
            int rnd = new Random().nextInt(values.length);
            WeatherStatus status = values[rnd];
            chunk.setData(AddonAttachmentRegistry.LOCAL_WEATHER, (Object)status);
        }
    }

    public static WeatherStatus getByPlayer(Player player) {
        ChunkPos pos = player.chunkPosition();
        Level level = player.level();
        return WeatherStatus.getByChunkPos((LevelReader)level, pos);
    }

    public static WeatherStatus getByBlockPos(LevelReader level, BlockPos blockPos) {
        ChunkPos pos = new ChunkPos(blockPos);
        return WeatherStatus.getByChunkPos(level, pos);
    }

    public static WeatherStatus getByChunkPos(LevelReader level, ChunkPos pos) {
        ChunkAccess chunk = level.getChunk(pos.x, pos.z);
        return chunk.getExistingData(AddonAttachmentRegistry.LOCAL_WEATHER).orElse(NONE);
    }

    public static float getRainLevel(WeatherStatus status) {
        return switch (status.ordinal()) {
            case 2, 3, 4 -> 1.0f;
            default -> 0.0f;
        };
    }

    public static boolean isRaining(WeatherStatus status) {
        return WeatherStatus.getRainLevel(status) > 0.0f;
    }

    public static Biome.Precipitation getPrecipitation(WeatherStatus status) {
        return switch (status.ordinal()) {
            case 2, 4 -> Biome.Precipitation.RAIN;
            case 3 -> Biome.Precipitation.SNOW;
            default -> Biome.Precipitation.NONE;
        };
    }

    static {
        CODEC = StringRepresentable.fromEnum(WeatherStatus::values);
        BY_ID = ByIdMap.continuous(WeatherStatus::getId, (Object[])WeatherStatus.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, WeatherStatus::getId);
    }
}

