/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items;

import artifacts.entity.MimicEntity;
import artifacts.registry.ModEntityTypes;
import it.hurts.octostudios.rarcompat.handlers.MimicHandler;
import it.hurts.sskirillss.relics.init.CreativeTabRegistry;
import it.hurts.sskirillss.relics.items.misc.CreativeContentConstructor;
import it.hurts.sskirillss.relics.items.misc.ICreativeTabContent;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.Vec3;

public class MimiDustItem
extends Item
implements ICreativeTabContent {
    public MimiDustItem() {
        super(new Item.Properties().rarity(Rarity.EPIC));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        Level level = context.getLevel();
        if (level.isClientSide()) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getClickedPos();
        if (level.getBlockState(pos).getBlock() != Blocks.CHEST || !((blockEntity = level.getBlockEntity(pos)) instanceof ChestBlockEntity)) {
            return InteractionResult.FAIL;
        }
        ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
        int count = 0;
        for (int i = 0; i < chest.getContainerSize(); ++i) {
            if (!MimicHandler.MIMIFICABLE.contains(chest.getItem(i).getItem())) continue;
            count += chest.getItem(i).getCount();
            chest.setItem(i, ItemStack.EMPTY);
        }
        if (count == 0) {
            return InteractionResult.FAIL;
        }
        context.getItemInHand().shrink(1);
        level.removeBlock(pos, true);
        MimicEntity mimic = new MimicEntity((EntityType)ModEntityTypes.MIMIC.get(), level);
        mimic.getPersistentData().putInt("relicCount", count);
        mimic.setPos((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5);
        mimic.setTarget((LivingEntity)context.getPlayer());
        level.addFreshEntity((Entity)mimic);
        float multiplier = (float)Math.pow(count, 1.7);
        EntityUtils.applyAttribute((LivingEntity)mimic, (ItemStack)ItemStack.EMPTY, (Holder)Attributes.ATTACK_DAMAGE, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
        EntityUtils.applyAttribute((LivingEntity)mimic, (ItemStack)ItemStack.EMPTY, (Holder)Attributes.MAX_HEALTH, (float)multiplier, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
        mimic.setHealth(mimic.getMaxHealth());
        Vec3 center = pos.getCenter();
        RandomSource random = mimic.getRandom();
        level.playSound(null, mimic.blockPosition(), SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM, mimic.getSoundSource(), 1.3f, 0.75f + mimic.getRandom().nextFloat());
        ((ServerLevel)level).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(200 + random.nextInt(50), 50 + random.nextInt(50), 200 + random.nextInt(50)), (float)0.25f, (int)60, (float)0.95f), center.x(), center.y(), center.z(), 50, 0.3, 0.3, 0.3, 0.015);
        return InteractionResult.SUCCESS;
    }

    public void gatherCreativeTabContent(CreativeContentConstructor constructor) {
        constructor.entry((CreativeModeTab)CreativeTabRegistry.RELICS_TAB.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS, new ItemStack[]{this.getDefaultInstance()});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"tooltip.rarcompat.mimi_dust").withStyle(ChatFormatting.DARK_PURPLE));
    }
}

