/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.BlockPhantom;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityPhantomface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class TileEntityPhantomEnergyface
extends TileEntityPhantomface
implements ISharingEnergyProvider {
    public TileEntityPhantomEnergyface(BlockPos pos, BlockState state) {
        super(ActuallyBlocks.PHANTOM_ENERGYFACE.getTileEntityType(), pos, state);
        this.type = BlockPhantom.Type.ENERGYFACE;
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomEnergyface) {
            TileEntityPhantomEnergyface tile = (TileEntityPhantomEnergyface)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityPhantomEnergyface) {
            TileEntityPhantomEnergyface tile = (TileEntityPhantomEnergyface)t;
            tile.serverTick();
        }
    }

    @Override
    public boolean isBoundThingInRange() {
        BlockEntity tile;
        if (super.isBoundThingInRange() && (tile = this.level.getBlockEntity(this.boundPosition)) != null && !(tile instanceof TileEntityLaserRelayEnergy)) {
            for (Direction facing : Direction.values()) {
                if (this.level.getCapability(Capabilities.EnergyStorage.BLOCK, tile.getBlockPos(), (Object)facing) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IEnergyStorage getEnergyStorage(Direction facing) {
        BlockEntity tile;
        if (this.isBoundThingInRange() && (tile = this.level.getBlockEntity(this.getBoundPosition())) != null) {
            return (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.getBoundPosition(), (Object)facing);
        }
        return null;
    }

    @Override
    public int getEnergyToSplitShare() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public Direction[] getEnergyShareSides() {
        return Direction.values();
    }

    @Override
    public boolean canShareTo(BlockEntity tile) {
        return true;
    }
}

