/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.gen;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.gen.ActuallyConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ActuallyPlacedFeatures {
    public static final ResourceKey<PlacedFeature> PLACED_ORE_BLACK_QUARTZ = ActuallyPlacedFeatures.createKey("ore_black_quartz");
    public static final ResourceKey<PlacedFeature> CANOLA_PATCH = ActuallyPlacedFeatures.createKey("canola_patch");
    public static final ResourceKey<PlacedFeature> FLAX_PATCH = ActuallyPlacedFeatures.createKey("flax_patch");
    public static final ResourceKey<PlacedFeature> COFFEE_PATCH = ActuallyPlacedFeatures.createKey("coffee_patch");
    public static final ResourceKey<PlacedFeature> RICE_PATCH = ActuallyPlacedFeatures.createKey("rice_patch");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter holdergetter = context.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(context, PLACED_ORE_BLACK_QUARTZ, (Holder)holdergetter.getOrThrow(ActuallyConfiguredFeatures.ORE_BLACK_QUARTZ), ActuallyPlacedFeatures.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-25), (VerticalAnchor)VerticalAnchor.absolute((int)45))));
        PlacementUtils.register(context, CANOLA_PATCH, (Holder)holdergetter.getOrThrow(ActuallyConfiguredFeatures.CANOLA_PATCH), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)8), NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, FLAX_PATCH, (Holder)holdergetter.getOrThrow(ActuallyConfiguredFeatures.FLAX_PATCH), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)8), NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, COFFEE_PATCH, (Holder)holdergetter.getOrThrow(ActuallyConfiguredFeatures.COFFEE_PATCH), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)8), NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
        PlacementUtils.register(context, RICE_PATCH, (Holder)holdergetter.getOrThrow(ActuallyConfiguredFeatures.RICE_PATCH), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)4), NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()});
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier modifier, PlacementModifier modifier1) {
        return List.of(modifier, InSquarePlacement.spread(), modifier1, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
        return ActuallyPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.of((int)count), modifier);
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ActuallyAdditions.modLoc(name));
    }
}

