/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.VoxelShapes;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Triple;

public class BlockGreenhouseGlass
extends BlockBase {
    public BlockGreenhouseGlass() {
        super(ActuallyBlocks.defaultPickProps(0.5f, 10.0f).sound(SoundType.GLASS).randomTicks());
    }

    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction side) {
        return adjacentState.is((Block)this) ? true : super.skipRendering(state, adjacentState, side);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (world.isClientSide) {
            return;
        }
        if (world.canSeeSkyFromBelowWater(pos) && world.isDay()) {
            Triple<BlockPos, BlockState, BonemealableBlock> trip = this.firstBlock((Level)world, pos);
            boolean once = false;
            if (trip != null) {
                for (int i = 0; i < 3; ++i) {
                    BlockState growState;
                    BlockState blockState = growState = i == 0 ? (BlockState)trip.getMiddle() : world.getBlockState((BlockPos)trip.getLeft());
                    if (growState.getBlock() != trip.getRight() || !((BonemealableBlock)trip.getRight()).isValidBonemealTarget((LevelReader)world, (BlockPos)trip.getLeft(), growState)) continue;
                    ((BonemealableBlock)trip.getRight()).performBonemeal(world, rand, (BlockPos)trip.getLeft(), growState);
                    once = true;
                }
            }
            if (once) {
                world.levelEvent(2005, ((BlockState)trip.getMiddle()).isSolidRender((BlockGetter)world, (BlockPos)trip.getLeft()) ? ((BlockPos)trip.getLeft()).above() : (BlockPos)trip.getLeft(), 0);
            }
        }
    }

    public Triple<BlockPos, BlockState, BonemealableBlock> firstBlock(Level world, BlockPos glassPos) {
        BlockState state;
        BlockPos.MutableBlockPos mut = new BlockPos((Vec3i)glassPos).mutable();
        do {
            mut.set(mut.getX(), mut.getY() - 1, mut.getZ());
            if (mut.getY() >= 0) continue;
            return null;
        } while (!(state = world.getBlockState((BlockPos)mut)).isSolidRender((BlockGetter)world, (BlockPos)mut) && !(state.getBlock() instanceof BonemealableBlock) && state.getBlock() != this);
        if (state.getBlock() instanceof BonemealableBlock) {
            return Triple.of((Object)mut.immutable(), (Object)state, (Object)((BonemealableBlock)state.getBlock()));
        }
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return VoxelShapes.GLASS_SHAPE;
    }
}

