/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.data;

import com.google.common.collect.ImmutableSet;
import de.ellpeck.actuallyadditions.api.ActuallyTags;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.components.ActuallyComponents;
import de.ellpeck.actuallyadditions.mod.fluids.InitFluids;
import de.ellpeck.actuallyadditions.mod.items.ActuallyItems;
import de.ellpeck.actuallyadditions.mod.misc.DungeonLoot;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class LootTableGenerator
extends LootTableProvider {
    public LootTableGenerator(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(Blocks::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(Dungeon::new, LootContextParamSets.CHEST), new LootTableProvider.SubProviderEntry(ItemWorm::new, LootContextParamSets.BLOCK)), lookupProvider);
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
        super.validate(writableregistry, validationcontext, problemreporter$collector);
    }

    public static class ItemWorm
    implements LootTableSubProvider {
        public static final ResourceKey<LootTable> WORM_DROP = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ActuallyAdditions.modLoc("worm_drop"));

        public ItemWorm(HolderLookup.Provider provider) {
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> pOutput) {
            pOutput.accept(WORM_DROP, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(ActuallyItems.WORM).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).when(LootItemRandomChanceCondition.randomChance((float)0.05f))));
        }
    }

    public static class Dungeon
    implements LootTableSubProvider {
        public Dungeon(HolderLookup.Provider provider) {
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> pOutput) {
            pOutput.accept(DungeonLoot.ENGINEER_HOUSE, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)4.0f, (float)7.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ActuallyBlocks.WOOD_CASING.getItem()).setWeight(60).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)10.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ActuallyBlocks.IRON_CASING.getItem()).setWeight(40).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ActuallyItems.BLACK_QUARTZ.get())).setWeight(20).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ActuallyItems.BATS_WING.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ActuallyItems.DRILL_CORE.get())).setWeight(5)).add((LootPoolEntryContainer.Builder)TagEntry.expandTag(ActuallyTags.Items.CRYSTALS).setWeight(20).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)TagEntry.expandTag(ActuallyTags.Items.CRYSTALS).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))));
        }
    }

    public static class Blocks
    extends BlockLootSubProvider {
        protected Blocks(HolderLookup.Provider lookupProvider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookupProvider);
        }

        protected void generate() {
            CopyComponentsFunction.Builder copyEnergy = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(ActuallyComponents.ENERGY_STORAGE.get());
            CopyComponentsFunction.Builder copyPulseMode = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(ActuallyComponents.PULSE_MODE.get());
            CopyComponentsFunction.Builder copyFluid_A = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(ActuallyComponents.FLUID_A.get());
            CopyComponentsFunction.Builder copyFluid_B = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(ActuallyComponents.FLUID_B.get());
            CopyComponentsFunction.Builder copyMiscInt = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(ActuallyComponents.MISC_INT.get());
            this.dropComponents(ActuallyBlocks.ATOMIC_RECONSTRUCTOR, $ -> $.apply((LootItemFunction.Builder)copyEnergy).apply((LootItemFunction.Builder)copyPulseMode));
            this.dropKeepEnergy(ActuallyBlocks.DISPLAY_STAND);
            this.dropKeepEnergy(ActuallyBlocks.COAL_GENERATOR);
            this.dropComponents(ActuallyBlocks.OIL_GENERATOR, $ -> $.apply((LootItemFunction.Builder)copyEnergy).apply((LootItemFunction.Builder)copyFluid_A));
            this.dropKeepEnergy(ActuallyBlocks.LEAF_GENERATOR);
            this.dropKeepEnergy(ActuallyBlocks.CRUSHER);
            this.dropKeepEnergy(ActuallyBlocks.CRUSHER_DOUBLE);
            this.dropKeepEnergy(ActuallyBlocks.POWERED_FURNACE);
            this.dropComponents(ActuallyBlocks.COFFEE_MACHINE, $ -> $.apply((LootItemFunction.Builder)copyEnergy).apply((LootItemFunction.Builder)copyFluid_A).apply((LootItemFunction.Builder)copyMiscInt));
            this.dropComponents(ActuallyBlocks.FLUID_COLLECTOR, $ -> $.apply((LootItemFunction.Builder)copyFluid_A).apply((LootItemFunction.Builder)copyPulseMode));
            this.dropComponents(ActuallyBlocks.FLUID_PLACER, $ -> $.apply((LootItemFunction.Builder)copyFluid_A).apply((LootItemFunction.Builder)copyPulseMode));
            this.dropKeepPulseMode(ActuallyBlocks.BREAKER);
            this.dropKeepPulseMode(ActuallyBlocks.PLACER);
            this.dropKeepPulseMode(ActuallyBlocks.DROPPER);
            this.dropComponents(ActuallyBlocks.CANOLA_PRESS, $ -> $.apply((LootItemFunction.Builder)copyEnergy).apply((LootItemFunction.Builder)copyFluid_A));
            this.dropComponents(ActuallyBlocks.FERMENTING_BARREL, $ -> $.apply((LootItemFunction.Builder)copyFluid_A).apply((LootItemFunction.Builder)copyFluid_B));
            this.dropKeepEnergy(ActuallyBlocks.FARMER);
            this.dropSelf(ActuallyBlocks.BATTERY_BOX.get());
            this.dropSelf(ActuallyBlocks.ITEM_INTERFACE_HOPPING.get());
            this.dropSelf(ActuallyBlocks.BIOREACTOR.get());
            this.dropSelf(ActuallyBlocks.EMPOWERER.get());
            this.dropSelf(ActuallyBlocks.TINY_TORCH.get());
            this.dropSelf(ActuallyBlocks.SHOCK_SUPPRESSOR.get());
            this.dropSelf(ActuallyBlocks.PLAYER_INTERFACE.get());
            this.dropSelf(ActuallyBlocks.ITEM_INTERFACE.get());
            this.dropSelf(ActuallyBlocks.FIREWORK_BOX.get());
            this.dropSelf(ActuallyBlocks.VERTICAL_DIGGER.get());
            this.dropSelf(ActuallyBlocks.ENERGIZER.get());
            this.dropSelf(ActuallyBlocks.ENERVATOR.get());
            this.dropSelf(ActuallyBlocks.LAVA_FACTORY_CONTROLLER.get());
            this.dropSelf(ActuallyBlocks.PHANTOM_ITEMFACE.get());
            this.dropSelf(ActuallyBlocks.PHANTOM_PLACER.get());
            this.dropSelf(ActuallyBlocks.PHANTOM_LIQUIFACE.get());
            this.dropSelf(ActuallyBlocks.PHANTOM_ENERGYFACE.get());
            this.dropSelf(ActuallyBlocks.PHANTOM_REDSTONEFACE.get());
            this.dropSelf(ActuallyBlocks.PHANTOM_BREAKER.get());
            this.dropSelf(ActuallyBlocks.FEEDER.get());
            this.dropSelf(ActuallyBlocks.HEAT_COLLECTOR.get());
            this.dropSelf(ActuallyBlocks.GREENHOUSE_GLASS.get());
            this.dropSelf(ActuallyBlocks.PHANTOM_BOOSTER.get());
            this.dropSelf(ActuallyBlocks.RANGED_COLLECTOR.get());
            this.dropSelf(ActuallyBlocks.LONG_RANGE_BREAKER.get());
            this.dropSelf(ActuallyBlocks.XP_SOLIDIFIER.get());
            this.dropSelf(ActuallyBlocks.LASER_RELAY.get());
            this.dropSelf(ActuallyBlocks.LASER_RELAY_ADVANCED.get());
            this.dropSelf(ActuallyBlocks.LASER_RELAY_EXTREME.get());
            this.dropSelf(ActuallyBlocks.LASER_RELAY_FLUIDS.get());
            this.dropSelf(ActuallyBlocks.LASER_RELAY_ITEM.get());
            this.dropSelf(ActuallyBlocks.LASER_RELAY_ITEM_ADVANCED.get());
            this.dropSelf(ActuallyBlocks.ETHETIC_GREEN_BLOCK.get());
            this.dropSelf(ActuallyBlocks.ETHETIC_WHITE_BLOCK.get());
            this.dropSelf(ActuallyBlocks.ETHETIC_GREEN_STAIRS.get());
            this.dropSelf(ActuallyBlocks.ETHETIC_WHITE_STAIRS.get());
            this.dropSelf(ActuallyBlocks.ETHETIC_GREEN_SLAB.get());
            this.dropSelf(ActuallyBlocks.ETHETIC_WHITE_SLAB.get());
            this.dropSelf(ActuallyBlocks.ETHETIC_GREEN_WALL.get());
            this.dropSelf(ActuallyBlocks.ETHETIC_WHITE_WALL.get());
            this.dropSelf(ActuallyBlocks.BLACK_QUARTZ.get());
            this.dropSelf(ActuallyBlocks.SMOOTH_BLACK_QUARTZ.get());
            this.dropSelf(ActuallyBlocks.CHISELED_BLACK_QUARTZ.get());
            this.dropSelf(ActuallyBlocks.BLACK_QUARTZ_PILLAR.get());
            this.dropSelf(ActuallyBlocks.BLACK_QUARTZ_BRICK.get());
            this.dropSelf(ActuallyBlocks.BLACK_QUARTZ_WALL.get());
            this.dropSelf(ActuallyBlocks.SMOOTH_BLACK_QUARTZ_WALL.get());
            this.dropSelf(ActuallyBlocks.CHISELED_BLACK_QUARTZ_WALL.get());
            this.dropSelf(ActuallyBlocks.BLACK_QUARTZ_PILLAR_WALL.get());
            this.dropSelf(ActuallyBlocks.BLACK_QUARTZ_BRICK_WALL.get());
            this.dropSelf(ActuallyBlocks.BLACK_QUARTZ_STAIR.get());
            this.dropSelf(ActuallyBlocks.SMOOTH_BLACK_QUARTZ_STAIR.get());
            this.dropSelf(ActuallyBlocks.CHISELED_BLACK_QUARTZ_STAIR.get());
            this.dropSelf(ActuallyBlocks.BLACK_QUARTZ_PILLAR_STAIR.get());
            this.dropSelf(ActuallyBlocks.BLACK_QUARTZ_BRICK_STAIR.get());
            this.dropSelf(ActuallyBlocks.BLACK_QUARTZ_SLAB.get());
            this.dropSelf(ActuallyBlocks.SMOOTH_BLACK_QUARTZ_SLAB.get());
            this.dropSelf(ActuallyBlocks.CHISELED_BLACK_QUARTZ_SLAB.get());
            this.dropSelf(ActuallyBlocks.BLACK_QUARTZ_PILLAR_SLAB.get());
            this.dropSelf(ActuallyBlocks.BLACK_QUARTZ_BRICK_SLAB.get());
            this.dropSelf(ActuallyBlocks.LAMP_WHITE.get());
            this.dropSelf(ActuallyBlocks.LAMP_ORANGE.get());
            this.dropSelf(ActuallyBlocks.LAMP_MAGENTA.get());
            this.dropSelf(ActuallyBlocks.LAMP_LIGHT_BLUE.get());
            this.dropSelf(ActuallyBlocks.LAMP_YELLOW.get());
            this.dropSelf(ActuallyBlocks.LAMP_LIME.get());
            this.dropSelf(ActuallyBlocks.LAMP_PINK.get());
            this.dropSelf(ActuallyBlocks.LAMP_GRAY.get());
            this.dropSelf(ActuallyBlocks.LAMP_LIGHT_GRAY.get());
            this.dropSelf(ActuallyBlocks.LAMP_CYAN.get());
            this.dropSelf(ActuallyBlocks.LAMP_PURPLE.get());
            this.dropSelf(ActuallyBlocks.LAMP_BLUE.get());
            this.dropSelf(ActuallyBlocks.LAMP_BROWN.get());
            this.dropSelf(ActuallyBlocks.LAMP_GREEN.get());
            this.dropSelf(ActuallyBlocks.LAMP_RED.get());
            this.dropSelf(ActuallyBlocks.LAMP_BLACK.get());
            this.dropSelf(ActuallyBlocks.LAMP_CONTROLLER.get());
            this.dropSelf(ActuallyBlocks.ENDER_CASING.get());
            this.dropSelf(ActuallyBlocks.IRON_CASING.get());
            this.dropSelf(ActuallyBlocks.LAVA_FACTORY_CASING.get());
            this.dropSelf(ActuallyBlocks.WOOD_CASING.get());
            this.dropSelf(ActuallyBlocks.ENORI_CRYSTAL.get());
            this.dropSelf(ActuallyBlocks.RESTONIA_CRYSTAL.get());
            this.dropSelf(ActuallyBlocks.PALIS_CRYSTAL.get());
            this.dropSelf(ActuallyBlocks.DIAMATINE_CRYSTAL.get());
            this.dropSelf(ActuallyBlocks.VOID_CRYSTAL.get());
            this.dropSelf(ActuallyBlocks.EMERADIC_CRYSTAL.get());
            this.dropSelf(ActuallyBlocks.EMPOWERED_ENORI_CRYSTAL.get());
            this.dropSelf(ActuallyBlocks.EMPOWERED_RESTONIA_CRYSTAL.get());
            this.dropSelf(ActuallyBlocks.EMPOWERED_PALIS_CRYSTAL.get());
            this.dropSelf(ActuallyBlocks.EMPOWERED_DIAMATINE_CRYSTAL.get());
            this.dropSelf(ActuallyBlocks.EMPOWERED_VOID_CRYSTAL.get());
            this.dropSelf(ActuallyBlocks.EMPOWERED_EMERADIC_CRYSTAL.get());
            this.registerCrystal(ActuallyBlocks.ENORI_CRYSTAL_CLUSTER, ActuallyItems.ENORI_CRYSTAL_SHARD);
            this.registerCrystal(ActuallyBlocks.RESTONIA_CRYSTAL_CLUSTER, ActuallyItems.RESTONIA_CRYSTAL_SHARD);
            this.registerCrystal(ActuallyBlocks.PALIS_CRYSTAL_CLUSTER, ActuallyItems.PALIS_CRYSTAL_SHARD);
            this.registerCrystal(ActuallyBlocks.DIAMATINE_CRYSTAL_CLUSTER, ActuallyItems.DIAMATINE_CRYSTAL_SHARD);
            this.registerCrystal(ActuallyBlocks.VOID_CRYSTAL_CLUSTER, ActuallyItems.VOID_CRYSTAL_SHARD);
            this.registerCrystal(ActuallyBlocks.EMERADIC_CRYSTAL_CLUSTER, ActuallyItems.EMERADIC_CRYSTAL_SHARD);
            this.add(ActuallyBlocks.BLACK_QUARTZ_ORE.get(), this.createOreDrop(ActuallyBlocks.BLACK_QUARTZ_ORE.getBlock(), (Item)ActuallyItems.BLACK_QUARTZ.get()));
            this.addCrop((Supplier<? extends Block>)ActuallyBlocks.CANOLA, (Supplier<? extends Item>)ActuallyItems.CANOLA, 2, 3, (Supplier<? extends Item>)ActuallyItems.CANOLA_SEEDS);
            this.addCrop((Supplier<? extends Block>)ActuallyBlocks.RICE, (Supplier<? extends Item>)ActuallyItems.RICE, 1, 2, (Supplier<? extends Item>)ActuallyItems.RICE_SEEDS);
            this.addCrop((Supplier<? extends Block>)ActuallyBlocks.FLAX, (Supplier<? extends Item>)((Supplier<Item>)() -> Items.STRING), 2, 4, (Supplier<? extends Item>)ActuallyItems.FLAX_SEEDS);
            this.addCrop((Supplier<? extends Block>)ActuallyBlocks.COFFEE, (Supplier<? extends Item>)ActuallyItems.COFFEE_BEANS, 2, 2, (Supplier<? extends Item>)ActuallyItems.COFFEE_BEANS);
        }

        private void addCrop(Supplier<? extends Block> block, Supplier<? extends Item> item, int min, int bonus, Supplier<? extends Item> seed) {
            HolderLookup.RegistryLookup registry = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
            LootItemBlockStatePropertyCondition.Builder cropCondition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block.get()).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlock.AGE, 7));
            LootTable.Builder table = LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)item.get())).when((LootItemCondition.Builder)cropCondition)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)(min + bonus)))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registry.getOrThrow(Enchantments.FORTUNE))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)seed.get()))))).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)seed.get())).when((LootItemCondition.Builder)cropCondition)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)registry.getOrThrow(Enchantments.FORTUNE)))));
            this.add(block.get(), (LootTable.Builder)this.applyExplosionDecay((ItemLike)block.get(), (FunctionUserBuilder)table));
        }

        private void dropComponents(Supplier<? extends Block> blockSupplier, Consumer<LootPool.Builder> lootFunctionProvider) {
            LootPool.Builder lootpool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)blockSupplier.get())));
            lootFunctionProvider.accept(lootpool);
            this.add(blockSupplier.get(), LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)ActuallyBlocks.ATOMIC_RECONSTRUCTOR.get(), (ConditionUserBuilder)lootpool)));
        }

        private void dropKeepPulseMode(Supplier<? extends Block> blockSupplier) {
            this.dropComponents(blockSupplier, $ -> $.apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(ActuallyComponents.PULSE_MODE.get())));
        }

        private void dropKeepEnergy(Supplier<? extends Block> blockSupplier) {
            this.dropComponents(blockSupplier, $ -> $.apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(ActuallyComponents.ENERGY_STORAGE.get())));
        }

        private void registerCrystal(Supplier<? extends Block> crystalCluster, DeferredItem<? extends Item> crystalShard) {
            this.add(crystalCluster.get(), block -> this.createSingleItemTableWithSilkTouch((Block)block, (ItemLike)crystalShard.get(), (NumberProvider)UniformGenerator.between((float)2.0f, (float)8.0f)));
        }

        protected Iterable<Block> getKnownBlocks() {
            ImmutableSet ignoreForNow = ImmutableSet.of((Object)InitFluids.CANOLA_OIL.getBlock(), (Object)InitFluids.REFINED_CANOLA_OIL.getBlock(), (Object)InitFluids.CRYSTALLIZED_OIL.getBlock(), (Object)InitFluids.EMPOWERED_OIL.getBlock());
            return ActuallyBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).filter(arg_0 -> Blocks.lambda$getKnownBlocks$11((Set)ignoreForNow, arg_0)).collect(Collectors.toList());
        }

        private static /* synthetic */ boolean lambda$getKnownBlocks$11(Set ignoreForNow, Block e) {
            return !ignoreForNow.contains(e);
        }
    }
}

