/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.compat.computercraft;

import com.mrh0.createaddition.blocks.redstone_relay.RedstoneRelayBlock;
import com.mrh0.createaddition.blocks.redstone_relay.RedstoneRelayBlockEntity;
import com.mrh0.createaddition.config.CommonConfig;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedstoneRelayPeripheral
implements IPeripheral {
    private final String type;
    private final RedstoneRelayBlockEntity tileEntity;

    public RedstoneRelayPeripheral(String type, RedstoneRelayBlockEntity tileEntity) {
        this.type = type;
        this.tileEntity = tileEntity;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    public boolean equals(@Nullable IPeripheral iPeripheral) {
        return iPeripheral == this;
    }

    @Nullable
    public Object getTarget() {
        return this.tileEntity;
    }

    @LuaFunction(mainThread=true)
    public final int getMaxInsert() {
        return (Integer)CommonConfig.SMALL_CONNECTOR_MAX_INPUT.get();
    }

    @LuaFunction(mainThread=true)
    public final int getMaxExtract() {
        return (Integer)CommonConfig.SMALL_CONNECTOR_MAX_OUTPUT.get();
    }

    @LuaFunction(mainThread=true)
    public final int getThroughput() {
        return this.tileEntity.getThroughput();
    }

    @LuaFunction(mainThread=true)
    public final boolean isPowered() {
        return (Boolean)this.tileEntity.getBlockState().getValue((Property)RedstoneRelayBlock.POWERED);
    }
}

